<?php

namespace App\Http\Controllers\API\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Middleware\CheckTFA;
use App\Http\Middleware\CustomVerified;
use App\Jobs\SendMeetingInvitationEmail;
use App\Models\Contact;
use App\Models\Meeting;
use Illuminate\Support\Facades\Auth;

class MeetingController extends Controller
{
   public function createMeetingApi(Request $request)
    {
        $request->validate([
            'meeting_id' => 'required|unique:meetings',
            'title' => 'required|min:3|max:100',
            'description' => 'max:1000',
            'password' => 'nullable|min:4|max:8',
            'date' => 'required',
            'time' => 'required',
            'timezone' => 'max:100'
        ]);

        $meeting = new Meeting();
        $meeting->meeting_id = $request->meeting_id;
        $meeting->title = $request->title;
        $meeting->description = $request->description;
        $meeting->user_id = $request->user()->id;
        $meeting->password = $request->password;
        $meeting->date = $request->date;
        $meeting->time = $request->time;
        $meeting->timezone = $request->timezone ?? "";

        if ($meeting->save()) {
            return response()->json([
                'success' => true, 
                'data' => [
                    'id' => $meeting->id,
                    'meeting_id' => $meeting->meeting_id,
                    'title' => $meeting->title,
                    'password' => $meeting->password,
                    'date' => $meeting->date,
                    'time' => $meeting->time,
                    'join_url' => route('online_class', $meeting->meeting_id),
                ]
            ]);
        }

        return response()->json(['success' => false, 'error' => 'Something went wrong'], 500);
    }

    public function editMeetingApi(Request $request, $id)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'max:1000',
            'password' => 'nullable|min:4|max:8',
            'date' => 'required',
            'time' => 'required',
            'timezone' => 'max:100'
        ]);

        $meeting = Meeting::where('id', $id)
            ->where('user_id', $request->user()->id)
            ->firstOrFail();

        $meeting->title = $request->title;
        $meeting->description = $request->description;
        $meeting->password = $request->password;
        $meeting->date = $request->date;
        $meeting->time = $request->time;
        $meeting->timezone = $request->timezone ?? "";

        if ($meeting->save()) {
            return response()->json([
                'success' => true, 
                'data' => $meeting
            ]);
        }

        return response()->json(['success' => false, 'error' => 'Something went wrong'], 500);
    }

    public function deleteMeetingApi(Request $request, $id)
    {
        $meeting = Meeting::where('id', $id)
            ->where('user_id', $request->user()->id)
            ->firstOrFail();

        if ($meeting->delete()) {
            return response()->json(['success' => true]);
        }

        return response()->json(['success' => false, 'error' => 'Something went wrong'], 500);
    }

}
