@extends('admin.payment-gateway.index')

@section('payment-gateway-content')
<form class="col-12 col-md-9 d-flex flex-column" action="{{ route('admin.payment_gateways.update-mollie') }}" method="post">
    @csrf
    <div class="card-body">
            <div class="tab-content" id="pills-tabContent">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-mollie">{{ __('Enabled') }}</label>
                            <select name="MOLLIE" id="i-mollie"
                                class="form-select  @error('MOLLIE') is-invalid @enderror">
                                @foreach ([1 => __('Yes'), 0 => __('No')] as $key => $value)
                                    <option value="{{ $key }}" @if ((old('MOLLIE') !== null && old('MOLLIE') == $key) || (getSetting('MOLLIE') == $key && old('MOLLIE') == null)) selected @endif>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('MOLLIE')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-api-key">{{ __('Secret') }}</label>
                            <input type="password" name="MOLLIE_API_KEY" id="i-api-key"
                                class="form-control @error('MOLLIE_API_KEY') is-invalid @enderror"
                                value="{{ old('MOLLIE_API_KEY') ?? getSetting('MOLLIE_API_KEY') }}"
                                placeholder="{{ __('Api Key') }}">
                            @error('MOLLIE_API_KEY')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
    </div>
    <div class="card-footer bg-transparent">
        <div class="btn-list justify-content-end">
            <button type="submit" name="submit" class="btn btn-primary mt-3">{{ __('Save') }}</button>
        </div>
    </div>
    </form>
@endsection
