@extends('admin.payment-gateway.index')

@section('payment-gateway-content')
    <form class="col-12 col-md-9 d-flex flex-column" action="{{ route('admin.payment_gateways.update-paypal') }}"
        method="post">
        @csrf
        <div class="card-body">
            <div class="tab-content" id="pills-tabContent">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-paypal">{{ __('Enabled') }}</label>
                            <select name="PAYPAL" id="i-paypal" class="form-select @error('PAYPAL') is-invalid @enderror">
                                @foreach ([1 => __('Yes'), 0 => __('No')] as $key => $value)
                                    <option value="{{ $key }}" @if ((old('PAYPAL') !== null && old('PAYPAL') == $key) || (getSetting('PAYPAL') == $key && old('PAYPAL') == null)) selected @endif>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('PAYPAL')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-paypal-mode">{{ __('Mode') }}</label>
                            <select name="PAYPAL_MODE" id="i-paypal-mode"
                                class="form-select @error('PAYPAL_MODE') is-invalid @enderror">
                                @foreach (['live' => __('Live'), 'sandbox' => __('Sandbox')] as $key => $value)
                                    <option value="{{ $key }}" @if (
                                        (old('PAYPAL_MODE') !== null && old('PAYPAL_MODE') == $key) ||
                                            (getSetting('PAYPAL_MODE') == $key && old('PAYPAL_MODE') == null)) selected @endif>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('PAYPAL_MODE')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-paypal-client-id">{{ __('Client ID') }}</label>
                            <input type="text" name="PAYPAL_CLIENT_ID" id="i-paypal-client-id"
                                class="form-control @error('PAYPAL_CLIENT_ID') is-invalid @enderror"
                                value="{{ old('PAYPAL_CLIENT_ID') ?? getSetting('PAYPAL_CLIENT_ID') }}"
                                placeholder="{{ __('Client ID') }}">
                            @error('PAYPAL_CLIENT_ID')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-paypal-secret">{{ __('Secret') }}</label>
                            <input type="password" name="PAYPAL_SECRET" id="i-paypal-secret"
                                class="form-control  @error('PAYPAL_SECRET') is-invalid @enderror"
                                value="{{ old('PAYPAL_SECRET') ?? getSetting('PAYPAL_SECRET') }}"
                                placeholder="{{ __('Secret') }}">
                            @error('PAYPAL_SECRET')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-paypal-webhook-id">{{ __('Webhook ID') }}</label>
                            <input type="text" name="PAYPAL_WEBHOOK_ID" id="i-paypal-webhook-id"
                                class="form-control @error('PAYPAL_WEBHOOK_ID') is-invalid @enderror"
                                value="{{ old('PAYPAL_WEBHOOK_ID') ?? getSetting('PAYPAL_WEBHOOK_ID') }}"
                                placeholder="{{ __('Webhook ID') }}">
                            @error('PAYPAL_WEBHOOK_ID')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-paypal-wh-url">{{ __('Webhook URL') }}</label>
                            <div class="input-group">
                                <input type="text" dir="ltr" name="paypal_wh_url" id="i-paypal-wh-url"
                                    class="form-control" value="{{ route('webhooks.paypal') }}" readonly>
                                <button class="btn btn-secondary" type="button" id="webhookUrlPaypalCopy">
                                    {{ __('Copy') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-footer bg-transparent">
            <div class="btn-list justify-content-end">
                <button type="submit" name="submit" class="btn btn-primary mt-3">{{ __('Save') }}</button>
            </div>
        </div>
    </form>
@endsection
