"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.RtpEncodingParametersT = exports.RtpEncodingParameters = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const rtx_1 = require("../../fbs/rtp-parameters/rtx");
class RtpEncodingParameters {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsRtpEncodingParameters(bb, obj) {
        return (obj || new RtpEncodingParameters()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsRtpEncodingParameters(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new RtpEncodingParameters()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    ssrc() {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : null;
    }
    rid(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    codecPayloadType() {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : null;
    }
    rtx(obj) {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? (obj || new rtx_1.Rtx()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    dtx() {
        const offset = this.bb.__offset(this.bb_pos, 12);
        return offset ? !!this.bb.readInt8(this.bb_pos + offset) : false;
    }
    scalabilityMode(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    maxBitrate() {
        const offset = this.bb.__offset(this.bb_pos, 16);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : null;
    }
    static startRtpEncodingParameters(builder) {
        builder.startObject(7);
    }
    static addSsrc(builder, ssrc) {
        builder.addFieldInt32(0, ssrc, null);
    }
    static addRid(builder, ridOffset) {
        builder.addFieldOffset(1, ridOffset, 0);
    }
    static addCodecPayloadType(builder, codecPayloadType) {
        builder.addFieldInt8(2, codecPayloadType, null);
    }
    static addRtx(builder, rtxOffset) {
        builder.addFieldOffset(3, rtxOffset, 0);
    }
    static addDtx(builder, dtx) {
        builder.addFieldInt8(4, +dtx, +false);
    }
    static addScalabilityMode(builder, scalabilityModeOffset) {
        builder.addFieldOffset(5, scalabilityModeOffset, 0);
    }
    static addMaxBitrate(builder, maxBitrate) {
        builder.addFieldInt32(6, maxBitrate, null);
    }
    static endRtpEncodingParameters(builder) {
        const offset = builder.endObject();
        return offset;
    }
    unpack() {
        return new RtpEncodingParametersT(this.ssrc(), this.rid(), this.codecPayloadType(), (this.rtx() !== null ? this.rtx().unpack() : null), this.dtx(), this.scalabilityMode(), this.maxBitrate());
    }
    unpackTo(_o) {
        _o.ssrc = this.ssrc();
        _o.rid = this.rid();
        _o.codecPayloadType = this.codecPayloadType();
        _o.rtx = (this.rtx() !== null ? this.rtx().unpack() : null);
        _o.dtx = this.dtx();
        _o.scalabilityMode = this.scalabilityMode();
        _o.maxBitrate = this.maxBitrate();
    }
}
exports.RtpEncodingParameters = RtpEncodingParameters;
class RtpEncodingParametersT {
    ssrc;
    rid;
    codecPayloadType;
    rtx;
    dtx;
    scalabilityMode;
    maxBitrate;
    constructor(ssrc = null, rid = null, codecPayloadType = null, rtx = null, dtx = false, scalabilityMode = null, maxBitrate = null) {
        this.ssrc = ssrc;
        this.rid = rid;
        this.codecPayloadType = codecPayloadType;
        this.rtx = rtx;
        this.dtx = dtx;
        this.scalabilityMode = scalabilityMode;
        this.maxBitrate = maxBitrate;
    }
    pack(builder) {
        const rid = (this.rid !== null ? builder.createString(this.rid) : 0);
        const rtx = (this.rtx !== null ? this.rtx.pack(builder) : 0);
        const scalabilityMode = (this.scalabilityMode !== null ? builder.createString(this.scalabilityMode) : 0);
        RtpEncodingParameters.startRtpEncodingParameters(builder);
        if (this.ssrc !== null)
            RtpEncodingParameters.addSsrc(builder, this.ssrc);
        RtpEncodingParameters.addRid(builder, rid);
        if (this.codecPayloadType !== null)
            RtpEncodingParameters.addCodecPayloadType(builder, this.codecPayloadType);
        RtpEncodingParameters.addRtx(builder, rtx);
        RtpEncodingParameters.addDtx(builder, this.dtx);
        RtpEncodingParameters.addScalabilityMode(builder, scalabilityMode);
        if (this.maxBitrate !== null)
            RtpEncodingParameters.addMaxBitrate(builder, this.maxBitrate);
        return RtpEncodingParameters.endRtpEncodingParameters(builder);
    }
}
exports.RtpEncodingParametersT = RtpEncodingParametersT;
