"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenInfoT = exports.ListenInfo = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const port_range_1 = require("../../fbs/transport/port-range");
const protocol_1 = require("../../fbs/transport/protocol");
const socket_flags_1 = require("../../fbs/transport/socket-flags");
class ListenInfo {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsListenInfo(bb, obj) {
        return (obj || new ListenInfo()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsListenInfo(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new ListenInfo()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    protocol() {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : protocol_1.Protocol.UDP;
    }
    ip(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    announcedAddress(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    exposeInternalIp() {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? !!this.bb.readInt8(this.bb_pos + offset) : false;
    }
    port() {
        const offset = this.bb.__offset(this.bb_pos, 12);
        return offset ? this.bb.readUint16(this.bb_pos + offset) : 0;
    }
    portRange(obj) {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? (obj || new port_range_1.PortRange()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    flags(obj) {
        const offset = this.bb.__offset(this.bb_pos, 16);
        return offset ? (obj || new socket_flags_1.SocketFlags()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    sendBufferSize() {
        const offset = this.bb.__offset(this.bb_pos, 18);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : 0;
    }
    recvBufferSize() {
        const offset = this.bb.__offset(this.bb_pos, 20);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : 0;
    }
    static startListenInfo(builder) {
        builder.startObject(9);
    }
    static addProtocol(builder, protocol) {
        builder.addFieldInt8(0, protocol, protocol_1.Protocol.UDP);
    }
    static addIp(builder, ipOffset) {
        builder.addFieldOffset(1, ipOffset, 0);
    }
    static addAnnouncedAddress(builder, announcedAddressOffset) {
        builder.addFieldOffset(2, announcedAddressOffset, 0);
    }
    static addExposeInternalIp(builder, exposeInternalIp) {
        builder.addFieldInt8(3, +exposeInternalIp, +false);
    }
    static addPort(builder, port) {
        builder.addFieldInt16(4, port, 0);
    }
    static addPortRange(builder, portRangeOffset) {
        builder.addFieldOffset(5, portRangeOffset, 0);
    }
    static addFlags(builder, flagsOffset) {
        builder.addFieldOffset(6, flagsOffset, 0);
    }
    static addSendBufferSize(builder, sendBufferSize) {
        builder.addFieldInt32(7, sendBufferSize, 0);
    }
    static addRecvBufferSize(builder, recvBufferSize) {
        builder.addFieldInt32(8, recvBufferSize, 0);
    }
    static endListenInfo(builder) {
        const offset = builder.endObject();
        builder.requiredField(offset, 6); // ip
        builder.requiredField(offset, 14); // port_range
        builder.requiredField(offset, 16); // flags
        return offset;
    }
    unpack() {
        return new ListenInfoT(this.protocol(), this.ip(), this.announcedAddress(), this.exposeInternalIp(), this.port(), (this.portRange() !== null ? this.portRange().unpack() : null), (this.flags() !== null ? this.flags().unpack() : null), this.sendBufferSize(), this.recvBufferSize());
    }
    unpackTo(_o) {
        _o.protocol = this.protocol();
        _o.ip = this.ip();
        _o.announcedAddress = this.announcedAddress();
        _o.exposeInternalIp = this.exposeInternalIp();
        _o.port = this.port();
        _o.portRange = (this.portRange() !== null ? this.portRange().unpack() : null);
        _o.flags = (this.flags() !== null ? this.flags().unpack() : null);
        _o.sendBufferSize = this.sendBufferSize();
        _o.recvBufferSize = this.recvBufferSize();
    }
}
exports.ListenInfo = ListenInfo;
class ListenInfoT {
    protocol;
    ip;
    announcedAddress;
    exposeInternalIp;
    port;
    portRange;
    flags;
    sendBufferSize;
    recvBufferSize;
    constructor(protocol = protocol_1.Protocol.UDP, ip = null, announcedAddress = null, exposeInternalIp = false, port = 0, portRange = null, flags = null, sendBufferSize = 0, recvBufferSize = 0) {
        this.protocol = protocol;
        this.ip = ip;
        this.announcedAddress = announcedAddress;
        this.exposeInternalIp = exposeInternalIp;
        this.port = port;
        this.portRange = portRange;
        this.flags = flags;
        this.sendBufferSize = sendBufferSize;
        this.recvBufferSize = recvBufferSize;
    }
    pack(builder) {
        const ip = (this.ip !== null ? builder.createString(this.ip) : 0);
        const announcedAddress = (this.announcedAddress !== null ? builder.createString(this.announcedAddress) : 0);
        const portRange = (this.portRange !== null ? this.portRange.pack(builder) : 0);
        const flags = (this.flags !== null ? this.flags.pack(builder) : 0);
        ListenInfo.startListenInfo(builder);
        ListenInfo.addProtocol(builder, this.protocol);
        ListenInfo.addIp(builder, ip);
        ListenInfo.addAnnouncedAddress(builder, announcedAddress);
        ListenInfo.addExposeInternalIp(builder, this.exposeInternalIp);
        ListenInfo.addPort(builder, this.port);
        ListenInfo.addPortRange(builder, portRange);
        ListenInfo.addFlags(builder, flags);
        ListenInfo.addSendBufferSize(builder, this.sendBufferSize);
        ListenInfo.addRecvBufferSize(builder, this.recvBufferSize);
        return ListenInfo.endListenInfo(builder);
    }
}
exports.ListenInfoT = ListenInfoT;
