"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.IceCandidateT = exports.IceCandidate = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const protocol_1 = require("../../fbs/transport/protocol");
const ice_candidate_type_1 = require("../../fbs/web-rtc-transport/ice-candidate-type");
class IceCandidate {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsIceCandidate(bb, obj) {
        return (obj || new IceCandidate()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsIceCandidate(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new IceCandidate()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    foundation(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    priority() {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : 0;
    }
    address(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    protocol() {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : protocol_1.Protocol.UDP;
    }
    port() {
        const offset = this.bb.__offset(this.bb_pos, 12);
        return offset ? this.bb.readUint16(this.bb_pos + offset) : 0;
    }
    type() {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : ice_candidate_type_1.IceCandidateType.HOST;
    }
    tcpType() {
        const offset = this.bb.__offset(this.bb_pos, 16);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : null;
    }
    static startIceCandidate(builder) {
        builder.startObject(7);
    }
    static addFoundation(builder, foundationOffset) {
        builder.addFieldOffset(0, foundationOffset, 0);
    }
    static addPriority(builder, priority) {
        builder.addFieldInt32(1, priority, 0);
    }
    static addAddress(builder, addressOffset) {
        builder.addFieldOffset(2, addressOffset, 0);
    }
    static addProtocol(builder, protocol) {
        builder.addFieldInt8(3, protocol, protocol_1.Protocol.UDP);
    }
    static addPort(builder, port) {
        builder.addFieldInt16(4, port, 0);
    }
    static addType(builder, type) {
        builder.addFieldInt8(5, type, ice_candidate_type_1.IceCandidateType.HOST);
    }
    static addTcpType(builder, tcpType) {
        builder.addFieldInt8(6, tcpType, null);
    }
    static endIceCandidate(builder) {
        const offset = builder.endObject();
        builder.requiredField(offset, 4); // foundation
        builder.requiredField(offset, 8); // address
        return offset;
    }
    static createIceCandidate(builder, foundationOffset, priority, addressOffset, protocol, port, type, tcpType) {
        IceCandidate.startIceCandidate(builder);
        IceCandidate.addFoundation(builder, foundationOffset);
        IceCandidate.addPriority(builder, priority);
        IceCandidate.addAddress(builder, addressOffset);
        IceCandidate.addProtocol(builder, protocol);
        IceCandidate.addPort(builder, port);
        IceCandidate.addType(builder, type);
        if (tcpType !== null)
            IceCandidate.addTcpType(builder, tcpType);
        return IceCandidate.endIceCandidate(builder);
    }
    unpack() {
        return new IceCandidateT(this.foundation(), this.priority(), this.address(), this.protocol(), this.port(), this.type(), this.tcpType());
    }
    unpackTo(_o) {
        _o.foundation = this.foundation();
        _o.priority = this.priority();
        _o.address = this.address();
        _o.protocol = this.protocol();
        _o.port = this.port();
        _o.type = this.type();
        _o.tcpType = this.tcpType();
    }
}
exports.IceCandidate = IceCandidate;
class IceCandidateT {
    foundation;
    priority;
    address;
    protocol;
    port;
    type;
    tcpType;
    constructor(foundation = null, priority = 0, address = null, protocol = protocol_1.Protocol.UDP, port = 0, type = ice_candidate_type_1.IceCandidateType.HOST, tcpType = null) {
        this.foundation = foundation;
        this.priority = priority;
        this.address = address;
        this.protocol = protocol;
        this.port = port;
        this.type = type;
        this.tcpType = tcpType;
    }
    pack(builder) {
        const foundation = (this.foundation !== null ? builder.createString(this.foundation) : 0);
        const address = (this.address !== null ? builder.createString(this.address) : 0);
        return IceCandidate.createIceCandidate(builder, foundation, this.priority, address, this.protocol, this.port, this.type, this.tcpType);
    }
}
exports.IceCandidateT = IceCandidateT;
