import type { Observer, LogEventListeners } from './indexTypes';
import type { Worker, WorkerSettings } from './WorkerTypes';
import type { RouterRtpCapabilities } from './rtpParametersTypes';
import type { AppData } from './types';
/**
 * Expose all types.
 */
export type * as types from './types';
/**
 * Expose mediasoup version.
 */
export declare const version: string;
declare const observer: Observer;
/**
 * Observer.
 */
export { observer };
/**
 * Full path of the mediasoup-worker binary.
 */
export { workerBin } from './Worker';
/**
 * Set event listeners for mediasoup generated logs. If called with no arguments
 * then no events will be emitted.
 *
 * @example
 * ```ts
 * mediasoup.setLogEventListeners({
 *   ondebug: undefined,
 *   onwarn: (namespace: string, log: string) => {
 *     MyEnterpriseLogger.warn(`${namespace} ${log}`);
 *   },
 *   onerror: (namespace: string, log: string, error?: Error) => {
 *     if (error) {
 *       MyEnterpriseLogger.error(`${namespace} ${log}: ${error}`);
 *     } else {
 *       MyEnterpriseLogger.error(`${namespace} ${log}`);
 *     }
 *   }
 * });
 * ```
 */
export declare function setLogEventListeners(listeners?: LogEventListeners): void;
/**
 * Create a Worker.
 */
export declare function createWorker<WorkerAppData extends AppData = AppData>({ logLevel, logTags, rtcMinPort, rtcMaxPort, dtlsCertificateFile, dtlsPrivateKeyFile, libwebrtcFieldTrials, disableLiburing, appData, }?: WorkerSettings<WorkerAppData>): Promise<Worker<WorkerAppData>>;
/**
 * Get a cloned copy of the mediasoup supported RTP capabilities.
 */
export declare function getSupportedRtpCapabilities(): RouterRtpCapabilities;
/**
 * Expose parseScalabilityMode() function.
 */
export { parseScalabilityMode } from './scalabilityModesUtils';
/**
 * Expose extras module.
 */
export * as extras from './extras';
//# sourceMappingURL=index.d.ts.map