
<?php $__env->startSection('title', $pageTitle); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('include.admin.toast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-xl">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <?php echo $__env->make('include.admin.breadcrumbs', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto me-3">
                        <div class="btn-list">
                            <span class="d-none d-sm-inline">
                                <a href="<?php echo e(route('export-meeting', request()->all())); ?>" class="btn hideLoader">
                                    <?php echo e(__('Export')); ?>

                                </a>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-xl">
                <div class="accordion mb-3" id="meetingSearch">
                    <div class="accordion-item">
                        <h4 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#meetingSearchForm" aria-expanded="true">
                                <?php echo e(__('Search')); ?>

                            </button>
                        </h4>
                        <div id="meetingSearchForm"
                            class="accordion-collapse collapse <?php if($isFiltered): ?> show <?php endif; ?>"
                            data-bs-parent="#meetingSearch">
                            <div class="accordion-body pt-0">
                                <?php echo $__env->make('admin.meeting.search', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="table-responsive">
                        <table class="table card-table table-vcenter text-nowrap datatable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('SR No')); ?></th>
                                    <th><?php echo e(__('Meeting ID')); ?></th>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Description')); ?></th>
                                    <th><?php echo e(__('Username')); ?></th>
                                    <th><?php echo e(__('Password')); ?></th>
                                    <th><?php echo e(__('Date')); ?></th>
                                    <th><?php echo e(__('Time')); ?></th>
                                    <th><?php echo e(__('Timezone')); ?></th>
                                    <th><?php echo e(__('Created Date')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $meetings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meeting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($meetings->firstItem() + $loop->index); ?></td>
                                        <td><?php echo e($meeting->meeting_id); ?></td>
                                        <td class="text-truncate" title="<?php echo e($meeting->title); ?>"><?php echo e($meeting->title); ?></td>
                                        <td class="text-truncate" title="<?php echo e($meeting->description ?? '-'); ?>">
                                            <?php echo e($meeting->description ?? '-'); ?>

                                        </td>
                                        <td><?php echo e($meeting->user ? $meeting->user->username : "-"); ?></td>
                                        <td><?php echo e($meeting->password ? $meeting->password : '-'); ?></td>
                                        <td><?php echo e($meeting->date ? $meeting->date : '-'); ?></td>
                                        <td><?php echo e($meeting->time ? $meeting->time : '-'); ?></td>
                                        <td class="text-truncate" title="<?php echo e($meeting->timezone ?? '-'); ?>">
                                            <?php echo e($meeting->timezone ? $meeting->timezone : '-'); ?></td>
                                        <td><?php echo e($meeting->created_at->diffForHumans()); ?></td>
                                        <td scope="col">
                                            <div class="form-switch">
                                                <input class="form-check-input toggle-meeting-status" type="checkbox"
                                                    data-id="<?php echo e($meeting->id); ?>"
                                                    value="<?php echo e($meeting->status === 'active' ? 'active' : 'inactive'); ?>"
                                                    <?php echo e($meeting->status === 'active' ? 'checked' : ''); ?>>
                                            </div>
                                        </td>
                                        <td>
                                            <a class="btn" href = "<?php echo e(route('admin.meeting.destroy', $meeting->id)); ?>"
                                                onclick="return confirm('Are you sure you want to delete this meeting?')"
                                                title="<?php echo e(__('Delete')); ?>">
                                                <?php echo e(__('Delete')); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td><?php echo e(__('No Records Found')); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php if($meetings->hasPages()): ?>
                        <div class="mt-2 ms-2">
                            <?php echo e($meetings->links('pagination::bootstrap-5')); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('js/litepicker.js')); ?>"></script>
    <script>
        const picker = new Litepicker({
            element: document.getElementById('litepicker'),
            singleMode: false,
            format: 'YYYY/MM/DD',
            autoApply: true,
        });

        $(document).ready(function() {
            $("#clearDate").click(function() {
                $("#litepicker").val("");
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/admin/meeting/index.blade.php ENDPATH**/ ?>