

<?php $__env->startSection('title', __('Login')); ?>

<?php $__env->startSection('content'); ?>
    <div class="page page-center">
        <div class="container container-tight py-4">
            <div class="text-center mb-4">
                <a href="<?php echo e(route('home')); ?>" class="navbar-brand navbar-brand-autodark">
                    <img src="<?php echo e(asset('storage/images/' . getSetting('PRIMARY_LOGO'))); ?>" width="200"
                        alt="<?php echo e(__('Logo')); ?>" class="navbar-brand-image">
                </a>
            </div>
            <div class="card card-md">
                <div class="card-body">
                    <h2 class="h2 text-center mb-4"><?php echo e(__('Login to your account')); ?></h2>
                    <form id="loginForm" method="POST" action="<?php echo e(route('login')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="mb-3">
                            <label class="form-label"><?php echo e(__('Email address or username')); ?></label>
                            <input id="email" type="text" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                name="email" value="<?php echo e(old('email')); ?>" maxlength="50"
                                placeholder="<?php echo e(__('Your email or username')); ?>" autocomplete="email" required autofocus>

                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mb-2">
                            <label class="form-label">
                                <?php echo e(__('Password')); ?>

                            </label>
                            <div class="input-group input-group-flat">
                                <input id="password" type="password"
                                    class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="<?php echo e(__('Password')); ?>" name="password" maxlength="50" required
                                    autocomplete="current-password">

                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <span class="input-group-text">
                                    <a class="link-secondary jm-toggle-password" data-bs-toggle="tooltip">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                            viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                            stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                            <path
                                                d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                                        </svg>
                                    </a>
                                </span>
                            </div>

                            <span class="form-label-description mt-2">
                                <a href="<?php echo e(route('password.request')); ?>"><?php echo e(__('Forgot your password?')); ?></a>
                            </span>
                        </div>
                        <div class="mb-2">
                            <label class="form-check">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember"
                                    <?php echo e(old('remember') ? 'checked' : ''); ?>>

                                <span class="form-check-label"><?php echo e(__('Remember me')); ?></span>
                            </label>
                        </div>

                        <?php if(getSetting('CAPTCHA_LOGIN_PAGE') == 'enabled'): ?>
                            <div class="form-group mt-5">
                                <div class="col-12">
                                    <div class="g-recaptcha" id="recaptcha-div"
                                        data-sitekey="<?php echo e(getSetting('GOOGLE_RECAPTCHA_KEY')); ?>">
                                    </div>
                                    <?php if($errors->has('g-recaptcha-response')): ?>
                                        <span class="invalid-feedback" role="alert" style="display: block">
                                            <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>

                        <div class="form-footer">
                            <button type="submit" id="loginButton"
                                class="btn btn-primary w-100"><?php echo e(__('Login')); ?></button>
                        </div>
                    </form>

                    <?php if(isDemoMode()): ?>
                        <div class="mt-3">
                            <select id="autoLogin" class="form-select">
                                <option value="">Auto login as (demo only)</option>
                                <option value="admin">Admin</option>
                                <option value="user_1">User 1</option>
                                <option value="user_2">User 2</option>
                            </select>
                        </div>
                    <?php endif; ?>
                </div>

                <?php echo $__env->make('auth.social-logins', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
            <?php if(getSetting('REGISTRATION') == 'enabled' && getSetting('AUTH_MODE') == 'enabled'): ?>
                <div class="text-center text-secondary mt-3">
                    <?php echo e(__("Don't have account yet?")); ?>

                    <a href="<?php echo e(route('register')); ?>" tabindex="-1">
                        <?php echo e(__('Register')); ?>

                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://www.google.com/recaptcha/api.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/auth/login.blade.php ENDPATH**/ ?>