
<?php $__env->startSection('title', $pageTitle); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('include.admin.toast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-xl">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <?php echo $__env->make('include.admin.breadcrumbs', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                    <div class="col-auto ms-auto me-3">
                        <div class="btn-list">
                            <span class="d-sm-inline">
                                <a href="<?php echo e(route('admin.plan.create')); ?>" class="btn btn-primary btn-5">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon me-0" width="24" height="24"
                                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M12 5l0 14" />
                                        <path d="M5 12l14 0" />
                                    </svg>
                                    <span class="d-none d-sm-inline-block"><?php echo e(__('Create New')); ?>

                                </a>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-xl">
                <div class="accordion mb-3" id="planSearch">
                    <div class="accordion-item">
                        <h4 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#planSearchForm" aria-expanded="true">
                                <?php echo e(__('Search')); ?>

                            </button>
                        </h4>
                        <div id="planSearchForm"
                            class="accordion-collapse collapse <?php if($isFiltered): ?> show <?php endif; ?>"
                            data-bs-parent="#planSearch">
                            <div class="accordion-body pt-0">
                                <?php echo $__env->make('admin.plan.search', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="table-responsive border rounded">
                        <table class="table align-middle text-nowrap mb-0">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('SR No')); ?></th>
                                    <th><?php echo e(__('Name')); ?></th>
                                    <th><?php echo e(__('Currency')); ?></th>
                                    <th><?php echo e(__('Monthly amount')); ?></th>
                                    <th><?php echo e(__('Yearly amount')); ?></th>
                                    <th><?php echo e(__('Description')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($plans->firstItem() + $loop->index); ?></td>
                                        <td><span class="text-truncate"><?php echo e($plan->name); ?></span>
                                            <?php if(!$plan->hasPrice()): ?>
                                                <span class="badge bg-danger-subtle text-danger"><?php echo e(__('Default')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($plan->currency ? $plan->currency : '-'); ?></td>
                                        <td><?php echo e($plan->amount_month ? $plan->amount_month : '-'); ?></td>
                                        <td><?php echo e($plan->amount_year ? $plan->amount_year : '-'); ?></td>
                                        <td class="text-truncate" title="<?php echo e($plan->description); ?>">
                                            <?php echo e($plan->description); ?></td>
                                        <td>
                                            <?php if($plan->id == 1): ?>
                                                -
                                            <?php else: ?>
                                                <div class="form-switch">
                                                    <input type="checkbox" class="form-check-input toggle-plan-status"
                                                        data-id="<?php echo e($plan->id); ?>"
                                                        <?php echo e($plan->status == 1 ? 'checked' : ''); ?>>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <a href = "<?php echo e(route('admin.plan.edit', $plan->id)); ?>" class="btn">
                                                <?php echo e(__('Edit')); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td><?php echo e(__('No Records Found')); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php if($plans->hasPages()): ?>
                        <div class="mt-2 ms-2">
                            <?php echo e($plans->links('pagination::bootstrap-5')); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/admin/plan/index.blade.php ENDPATH**/ ?>