

<?php $__env->startSection('title', trans('installer_messages.requirements.title')); ?>
<?php $__env->startSection('container'); ?>
    <div class="card card-md">
        <div class="card-body text-center py-4 p-sm-5">
            <h2 class="mb-5 text-center">Requirements Check</h2>
            <div class="list-group list-group-flush list-group-hoverable">
                <?php if(isset($requirements['errors']) || $phpSupportInfo['supported'] != 'success'): ?>
                    <div class="alert alert-danger">Please fix the below error and the click
                        Check Requirements Again</div>
                <?php endif; ?>
                <div class="list-group-item">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-auto">
                            <span>PHP Version >= <?php echo e($phpSupportInfo['minimum']); ?></span>
                        </div>
                        <div class="col-auto">
                            <?php echo $phpSupportInfo['supported']
                                ? '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon text-green icon-2">
                                                                                                                                                                                                                                                                                                                                                                                            <path d="M5 12l5 5l10 -10"></path>
                                                                                                                                                                                                                                                                                                                                                                                        </svg>'
                                : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon text-red icon-2">
                                                                                                                                                                                                                                                                                                                                                                                            <path d="M18 6l-12 12"></path>
                                                                                                                                                                                                                                                                                                                                                                                            <path d="M6 6l12 12"></path>
                                                                                                                                                                                                                                                                                                                                                                                        </svg>'; ?>

                        </div>
                    </div>
                </div>
                <?php $__currentLoopData = $requirements['requirements']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extention => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="list-group-item">
                        <div class="row align-items-center justify-content-between">
                            <div class="col-auto">
                                <span><?php echo e($extention); ?></span>
                            </div>
                            <div class="col-auto">
                                <?php echo $enabled
                                    ? '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon text-green icon-2">
                                                                                                                                                                                                                                                                                                                                                                                                                                            <path d="M5 12l5 5l10 -10"></path>
                                                                                                                                                                                                                                                                                                                                                                                                                                        </svg>'
                                    : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon text-red icon-2">
                                                                                                                                                                                                                                                                                                                                                                                                                                            <path d="M18 6l-12 12"></path>
                                                                                                                                                                                                                                                                                                                                                                                                                                            <path d="M6 6l12 12"></path>
                                                                                                                                                                                                                                                                                                                                                                                                                                        </svg>'; ?>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <div class="row align-items-center mt-3">
        <div class="col-4">
            <div class="progress progress-1">
                <div class="progress-bar" style="width: 60%;" role="progressbar" aria-valuenow="50" aria-valuemin="0"
                    aria-valuemax="100" aria-label="60% Complete">
                    <span class="visually-hidden">60% Complete</span>
                </div>
            </div>
        </div>
        <div class="col">
            <?php if(!isset($requirements['errors']) && $phpSupportInfo['supported'] == 'success'): ?>
                <div class="btn-list justify-content-end">
                    <a href="<?php echo e(route('LaravelInstaller::permissions')); ?>" class="btn btn-primary btn-2"> Next </a>
                </div>
            <?php else: ?>
                <div class="btn-list justify-content-end">
                    <a class="btn btn-primary btn-2" href="javascript:window.location.href='';">
                        Check Requirements Again
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('vendor.installer.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/vendor/installer/requirements.blade.php ENDPATH**/ ?>