
<?php $__env->startSection('title', $pageTitle); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('include.admin.toast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="page-wrapper">
        <!-- Page header -->
        <div class="page-header d-print-none">
            <div class="container-xl">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <?php echo $__env->make('include.admin.breadcrumbs', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto me-3">
                        <div class="btn-list">
                            <span class="d-none d-sm-inline">
                                <a href="<?php echo e(route('export-activity-log', request()->all())); ?>" class="btn hideLoader">
                                    <?php echo e(__('Export')); ?>

                                </a>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-xl">
                <div class="accordion mb-3" id="activityLogSearch">
                    <div class="accordion-item">
                        <h4 class="accordion-header">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#activityLogSearchForm" aria-expanded="true">
                                <?php echo e(__('Search')); ?>

                            </button>
                        </h4>
                        <div id="activityLogSearchForm"
                            class="accordion-collapse collapse
                                 <?php if($isFiltered): ?> show <?php endif; ?>
                                 "
                            data-bs-parent="#activityLogSearch">
                            <div class="accordion-body pt-0">
                                <?php echo $__env->make('admin.activity-log.search', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="table-responsive">
                        <table class="table card-table table-vcenter text-nowrap datatable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('SR No')); ?></th>
                                    <th><?php echo e(__('User')); ?></th>
                                    <th><?php echo e(__('Event Type')); ?></th>
                                    <th><?php echo e(__('Log')); ?></th>
                                    <th><?php echo e(__('IP')); ?></th>
                                    <th><?php echo e(__('Created At')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $activityLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activityLog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($activityLogs->firstItem() + $loop->index); ?></td>
                                        <td><?php echo e($activityLog->causer ? $activityLog->causer->username : "-"); ?></td>
                                        <td>
                                            <?php if($activityLog->event == 'Logged In' || $activityLog->event == 'Logged Out' || $activityLog->event == 'Registered'): ?>
                                                <?php echo e($activityLog->event); ?>

                                            <?php else: ?>
                                                <?php echo e($activityLog->log_name . ' ' . $activityLog->event); ?>

                                                <?php if($activityLog->event == 'created' && !$activityLog->causer): ?>
                                                    <?php echo e(__('from Social Login')); ?></span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php $__currentLoopData = json_decode($activityLog->properties, true) ?: []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $innerArray): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(is_array($innerArray)): ?>
                                                    <?php $__currentLoopData = $innerArray; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $innerKey => $innerValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($innerValue): ?>
                                                            <?php if($key === 'old'): ?>
                                                                <?php echo e(__('Old:')); ?>

                                                            <?php elseif($key === 'attributes'): ?>
                                                                <?php echo e(__('Attribute:')); ?>

                                                            <?php endif; ?>
                                                            <?php echo e($innerKey); ?> -
                                                            <?php if($innerKey == 'content' && $activityLog->log_name == 'Email Template'): ?>
                                                                Email template content has been updated
                                                            <?php elseif($innerKey == 'content' && $activityLog->log_name == 'Page'): ?>
                                                                Content
                                                            <?php elseif($innerKey == 'content' && $activityLog->log_name == 'Page' && $activityLog->event == 'updated'): ?>
                                                                Page Content has been updated
                                                            <?php elseif($innerKey == 'features' && $activityLog->log_name == 'Plan' && $activityLog->event == 'updated'): ?>
                                                                Plan Features has been updated
                                                            <?php elseif($innerKey == 'features' && $activityLog->log_name == 'Plan' && $activityLog->event == 'created'): ?>
                                                                Plan Features has been created
                                                            <?php elseif($innerKey == 'regions' && $activityLog->log_name == 'Tax rate' && $activityLog->event == 'created'): ?>
                                                                Regions have been set for this tax rate.
                                                            <?php elseif($innerKey == 'regions' && $activityLog->log_name == 'Tax rate' && $activityLog->event == 'updated'): ?>
                                                                Regions have been updated for this taxrate
                                                            <?php elseif($innerKey == 'coupons' && $activityLog->log_name == 'Plan' && $activityLog->event == 'updated'): ?>
                                                                Coupons have been updated
                                                            <?php elseif($innerKey == 'tax_rates' && $activityLog->log_name == 'Plan' && $activityLog->event == 'updated'): ?>
                                                                Taxrates have been updated
                                                            <?php elseif($innerKey == 'tax_rates' && $activityLog->log_name == 'Plan' && $activityLog->event == 'created'): ?>
                                                                Taxrates have been created
                                                            <?php elseif($innerKey == 'coupons' && $activityLog->log_name == 'Plan' && $activityLog->event == 'created'): ?>
                                                                Coupons have been created
                                                            <?php else: ?>
                                                                <span title="<?php echo e($innerValue); ?>">
                                                                    <?php echo e(\Illuminate\Support\Str::limit($innerValue, 20, '...')); ?>

                                                                </span>
                                                            <?php endif; ?>
                                                            <br>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                        <td><?php echo e($activityLog->ip); ?></td>
                                        <td><?php echo e($activityLog->created_at->diffForHumans()); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td><?php echo e(__('No Records Found')); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php if($activityLogs->hasPages()): ?>
                        <div class="mt-2 ms-2">
                            <?php echo e($activityLogs->links('pagination::bootstrap-5')); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('js/litepicker.js')); ?>"></script>
    <script>
        const picker = new Litepicker({
            element: document.getElementById('litepicker'),
            singleMode: false,
            format: 'YYYY/MM/DD',
            autoApply: true,
        });

        $(document).ready(function() {
            $("#clearDate").click(function() {
                $("#litepicker").val("");
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /www/wwwroot/skweela_net/resources/views/admin/activity-log/index.blade.php ENDPATH**/ ?>