<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateTaxrateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules()
    {
        return [
            'name' => ['required','min:3', 'max:128'],
            'type' => ['required', 'min:0', 'max:1'],
            'percentage' => ['required', 'numeric', 'min:1', 'max:100'],
            'regions' => ['sometimes', 'nullable']
        ];
    }
}