<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meetings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('meeting_id', 9);
            $table->string('title', 100);
            $table->string('description', 1000)->nullable();
            $table->text('invites')->nullable();
            $table->integer('user_id');
            $table->string('password', 8)->nullable();
            $table->enum('status', ['active', 'inactive']);
            $table->date('date')->nullable();
            $table->time('time')->nullable();
            $table->string('timezone', 100)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meetings');
    }
};
