@extends('admin.payment-gateway.index')

@section('payment-gateway-content')
    <form class="col-12 col-md-9 d-flex flex-column" action="{{ route('admin.payment_gateways.update-stripe') }}"
        method="post">
        @csrf
        <div class="card-body">
            <div class="tab-content" id="pills-tabContent">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-stripe">{{ __('Enabled') }}</label>
                            <select name="STRIPE" id="i-stripe" class="form-select @error('STRIPE') is-invalid @enderror">
                                @foreach ([1 => __('Yes'), 0 => __('No')] as $key => $value)
                                    <option value="{{ $key }}" @if ((old('STRIPE') !== null && old('STRIPE') == $key) || (getSetting('STRIPE') == $key && old('STRIPE') == null)) selected @endif>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('STRIPE')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-stripe-key">{{ __('Publishable key') }}</label>
                            <input type="text" name="STRIPE_KEY" id="i-stripe-key"
                                class="form-control @error('STRIPE_KEY') is-invalid @enderror"
                                value="{{ old('STRIPE_KEY') ?? getSetting('STRIPE_KEY') }}"
                                placeholder="{{ __('Publishable key') }}">
                            @error('STRIPE_KEY')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-stripe-secret">{{ __('Secret key') }}</label>
                            <input type="password" name="STRIPE_SECRET" id="i-stripe-secret"
                                class="form-control @error('STRIPE_SECRET') is-invalid @enderror"
                                value="{{ old('STRIPE_SECRET') ?? getSetting('STRIPE_SECRET') }}"
                                placeholder="{{ __('Secret key') }}">
                            @error('STRIPE_SECRET')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-stripe-wh-secret">{{ __('Signing secret') }}</label>
                            <input type="password" name="STRIPE_WH_SECRET" id="i-stripe-wh-secret"
                                class="form-control @error('STRIPE_WH_SECRET') is-invalid @enderror"
                                value="{{ old('STRIPE_WH_SECRET') ?? getSetting('STRIPE_WH_SECRET') }}"
                                placeholder="{{ __('Signing secret') }}">
                            @error('STRIPE_WH_SECRET')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label class="form-label" for="i-stripe-wh-url">{{ __('Webhook URL') }}</label>
                            <div class="input-group">
                                <input type="text" dir="ltr" name="stripe_wh_url" id="i-stripe-wh-url"
                                    class="form-control" value="{{ route('webhooks.stripe') }}" readonly>
                                <button class="btn btn-secondary" type="button" id="webhookUrlStripeCopy">
                                    {{ __('Copy') }}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-footer bg-transparent">
            <div class="btn-list justify-content-end">
                <button type="submit" name="submit" class="btn btn-primary mt-3">{{ __('Save') }}</button>
            </div>
        </div>
    </form>
@endsection
