@extends('admin.setting.index')

@section('setting-content')
    <form class="col-12 col-md-9 d-flex flex-column" action="{{ route('admin.setting.update-google-recaptcha') }}"
        method="post">
        @csrf
        <div class="card-body">
            <h2 class="mb-4">{{ __(key: 'Google ReCaptcha') }}</h2>


            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Key') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Key') }}"></i>
                        </label>
                        <input type="text" name="GOOGLE_RECAPTCHA_KEY" maxlength="100"
                            class="form-control @error('GOOGLE_RECAPTCHA_KEY') is-invalid @enderror"
                            value="{{ old('GOOGLE_RECAPTCHA_KEY') ?? getSetting('GOOGLE_RECAPTCHA_KEY') }}"
                            placeholder="{{ __('reCAPTCHA Key') }}">
                        @error('GOOGLE_RECAPTCHA_KEY')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>

                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Secret') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Secret') }}"></i>
                        </label>
                        <input type="text" name="GOOGLE_RECAPTCHA_SECRET" maxlength="100"
                            class="form-control @error('GOOGLE_RECAPTCHA_SECRET') is-invalid @enderror"
                            value="{{ old('GOOGLE_RECAPTCHA_SECRET') ?? getSetting('GOOGLE_RECAPTCHA_SECRET') }}"
                            placeholder="{{ __('reCAPTCHA Secret') }}">
                        @error('GOOGLE_RECAPTCHA_SECRET')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>
            <hr>
            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Login Page') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('This will add a Google reCAPTCHA validation on the login page.') }}"></i>
                        </label>
                        <select name="CAPTCHA_LOGIN_PAGE"
                            class="form-control @error('CAPTCHA_LOGIN_PAGE') is-invalid @enderror">
                            <option value="enabled" @selected(old('CAPTCHA_LOGIN_PAGE') ? old('CAPTCHA_LOGIN_PAGE') == 'enabled' : getSetting('CAPTCHA_LOGIN_PAGE') == 'enabled')>
                                {{ __('On') }}
                            </option>
                            <option value="disabled" @selected(old('CAPTCHA_LOGIN_PAGE') ? old('CAPTCHA_LOGIN_PAGE') == 'disabled' : getSetting('CAPTCHA_LOGIN_PAGE') == 'disabled')>
                                {{ __('Off') }}
                            </option>
                        </select>
                        @error('CAPTCHA_LOGIN_PAGE')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>

                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Register Page') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('This will add a Google reCAPTCHA validation on the register page.') }}"></i>
                        </label>
                        <select name="CAPTCHA_REGISTER_PAGE"
                            class="form-control @error('CAPTCHA_REGISTER_PAGE') is-invalid @enderror">
                            <option value="enabled" @selected(old('CAPTCHA_REGISTER_PAGE') ? old('CAPTCHA_REGISTER_PAGE') == 'enabled' : getSetting('CAPTCHA_REGISTER_PAGE') == 'enabled')>
                                {{ __('On') }}
                            </option>
                            <option value="disabled" @selected(old('CAPTCHA_REGISTER_PAGE') ? old('CAPTCHA_REGISTER_PAGE') == 'disabled' : getSetting('CAPTCHA_REGISTER_PAGE') == 'disabled')>
                                {{ __('Off') }}
                            </option>
                        </select>
                        @error('CAPTCHA_REGISTER_PAGE')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Checkout Page') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('This will add a Google reCAPTCHA validation on the checkout page.') }}"></i>
                        </label>
                        <select name="GOOGLE_RECAPTCHA"
                            class="form-control @error('GOOGLE_RECAPTCHA') is-invalid @enderror">
                            <option value="enabled" @selected(old('GOOGLE_RECAPTCHA') ? old('GOOGLE_RECAPTCHA') == 'enabled' : getSetting('GOOGLE_RECAPTCHA') == 'enabled')>
                                {{ __('On') }}
                            </option>
                            <option value="disabled" @selected(old('GOOGLE_RECAPTCHA') ? old('GOOGLE_RECAPTCHA') == 'disabled' : getSetting('GOOGLE_RECAPTCHA') == 'disabled')>
                                {{ __('Off') }}
                            </option>
                        </select>
                        @error('GOOGLE_RECAPTCHA')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

        </div>
        <div class="card-footer bg-transparent">
            <div class="btn-list justify-content-end">
                <button type="submit" name="submit" class="btn btn-primary mt-3">{{ __('Save') }}</button>
            </div>
        </div>
    </form>
@endsection
