@extends('layouts.auth')

@section('title', __('Register'))

@section('content')
    <div class="page page-center">
        <div class="container container-tight py-4">
            <div class="text-center mb-4">
                <a href="{{ route('home') }}" class="navbar-brand navbar-brand-autodark">
                    <img src="{{ asset('/storage/images/' . getSetting('PRIMARY_LOGO')) }}" width="200"
                        alt="{{ __('Logo') }}" class="navbar-brand-image">
                </a>
            </div>
            <form class="card card-md" method="POST" action="{{ route('register') }}">
                @csrf

                <div class="card-body">
                    <h2 class="card-title text-center mb-4">{{ __('Create new account') }}</h2>
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <label class="form-label">{{ __('First Name') }} </label>
                            <input type="text" value="{{ old('first_name') }}"
                                class="form-control @error('first_name') is-invalid @enderror" name="first_name"
                                placeholder="{{ __('Enter first name') }}" required autofocus maxlength="25">
                            @error('first_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">{{ __('Last Name') }}</label>
                            <input type="text" value="{{ old('last_name') }}"
                                class="form-control @error('last_name') is-invalid @enderror" name="last_name"
                                placeholder="{{ __('Enter last name') }}" required maxlength="25">
                            @error('last_name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Username') }}</label>
                        <input type="text" class="form-control @error('username') is-invalid @enderror" maxlength="20"
                            value="{{ old('username') }}" name="username" placeholder="{{ __('Enter username') }}"
                            required>
                        @error('username')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Email address') }}</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" maxlength="50"
                            value="{{ old('email') }}" name="email" placeholder="{{ __('Enter email') }}" required>
                        @error('email')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Password') }}</label>
                        <div class="input-group input-group-flat">
                            <input type="password" class="form-control @error('password') is-invalid @enderror"
                                minlength="6" name="password" placeholder="{{ __('Password') }}" autocomplete="off"
                                required>
                            <span class="input-group-text">
                                <a href="#" class="link-secondary jm-toggle-password" data-bs-toggle="tooltip">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                        <path
                                            d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                                    </svg>
                                </a>
                            </span>
                            @error('password')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-check">
                            <input class="form-check-input @error('terms') is-invalid @enderror" type="checkbox"
                                name="terms">
                            <span class="form-check-label">{{ __('Agree the') }} <a
                                    href="{{ route('pages.show', 'terms-and-conditions') }}"
                                    tabindex="-1">{{ __('terms and policy') }}</a>.</span>
                            @error('terms')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </label>
                    </div>
                    @if (getSetting('CAPTCHA_REGISTER_PAGE') == 'enabled')
                        <div class="form-group">
                            <div class="col-12">
                                <div class="g-recaptcha" data-sitekey="{{ getSetting('GOOGLE_RECAPTCHA_KEY') }}">
                                </div>
                                @if ($errors->has('g-recaptcha-response'))
                                    <span class="invalid-feedback" role="alert" style="display: block">
                                        <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    @endif
                    <div class="form-footer">
                        <button type="submit" class="btn btn-primary w-100">{{ __('Register') }}</button>
                    </div>

                </div>
            </form>
            <div class="text-center text-secondary mt-3">
                {{ __('Already have account?') }} <a href="{{ route('login') }}" tabindex="-1">{{ __('Login') }}</a>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="https://www.google.com/recaptcha/api.js"></script>
@endsection
