import { EnhancedEventEmitter } from './enhancedEvents';
import type { DataConsumer, DataConsumerType, DataConsumerDump, DataConsumerStat, DataConsumerEvents, DataConsumerObserver } from './DataConsumerTypes';
import { Channel } from './Channel';
import type { TransportInternal } from './Transport';
import type { SctpStreamParameters } from './sctpParametersTypes';
import type { AppData } from './types';
import * as FbsDataConsumer from './fbs/data-consumer';
import * as FbsDataProducer from './fbs/data-producer';
type DataConsumerInternal = TransportInternal & {
    dataConsumerId: string;
};
type DataConsumerData = {
    dataProducerId: string;
    type: DataConsumerType;
    sctpStreamParameters?: SctpStreamParameters;
    label: string;
    protocol: string;
    bufferedAmountLowThreshold: number;
};
export declare class DataConsumerImpl<DataConsumerAppData extends AppData = AppData> extends EnhancedEventEmitter<DataConsumerEvents> implements DataConsumer {
    #private;
    constructor({ internal, data, channel, paused, dataProducerPaused, subchannels, appData, }: {
        internal: DataConsumerInternal;
        data: DataConsumerData;
        channel: Channel;
        paused: boolean;
        dataProducerPaused: boolean;
        subchannels: number[];
        appData?: DataConsumerAppData;
    });
    get id(): string;
    get dataProducerId(): string;
    get closed(): boolean;
    get type(): DataConsumerType;
    get sctpStreamParameters(): SctpStreamParameters | undefined;
    get label(): string;
    get protocol(): string;
    get paused(): boolean;
    get dataProducerPaused(): boolean;
    get subchannels(): number[];
    get appData(): DataConsumerAppData;
    set appData(appData: DataConsumerAppData);
    get observer(): DataConsumerObserver;
    close(): void;
    transportClosed(): void;
    dump(): Promise<DataConsumerDump>;
    getStats(): Promise<DataConsumerStat[]>;
    pause(): Promise<void>;
    resume(): Promise<void>;
    setBufferedAmountLowThreshold(threshold: number): Promise<void>;
    getBufferedAmount(): Promise<number>;
    send(message: string | Buffer, ppid?: number): Promise<void>;
    setSubchannels(subchannels: number[]): Promise<void>;
    addSubchannel(subchannel: number): Promise<void>;
    removeSubchannel(subchannel: number): Promise<void>;
    private handleWorkerNotifications;
    private handleListenerError;
}
export declare function dataConsumerTypeToFbs(type: DataConsumerType): FbsDataProducer.Type;
export declare function dataConsumerTypeFromFbs(type: FbsDataProducer.Type): DataConsumerType;
export declare function parseDataConsumerDumpResponse(data: FbsDataConsumer.DumpResponse): DataConsumerDump;
export {};
//# sourceMappingURL=DataConsumer.d.ts.map