import { EnhancedEventEmitter } from './enhancedEvents';
import type { Transport, TransportType, TransportProtocol, TransportPortRange, TransportSocketFlags, TransportTuple, SctpState, BaseTransportDump, BaseTransportStats, TransportTraceEventType, TransportTraceEventData, TransportEvents, TransportObserver } from './TransportTypes';
import type { Channel } from './Channel';
import type { RouterInternal } from './Router';
import type { WebRtcTransportData } from './WebRtcTransport';
import type { PlainTransportData } from './PlainTransport';
import type { PipeTransportData } from './PipeTransport';
import type { DirectTransportData } from './DirectTransport';
import type { Producer, ProducerOptions } from './ProducerTypes';
import type { Consumer, ConsumerOptions } from './ConsumerTypes';
import type { DataProducer, DataProducerOptions } from './DataProducerTypes';
import type { DataConsumer, DataConsumerOptions } from './DataConsumerTypes';
import type { RtpCapabilities } from './rtpParametersTypes';
import type { AppData } from './types';
import * as FbsTransport from './fbs/transport';
import { SctpState as FbsSctpState } from './fbs/sctp-association/sctp-state';
export type TransportConstructorOptions<TransportAppData> = {
    internal: TransportInternal;
    data: TransportData;
    channel: Channel;
    appData?: TransportAppData;
    getRouterRtpCapabilities: () => RtpCapabilities;
    getProducerById: (producerId: string) => Producer | undefined;
    getDataProducerById: (dataProducerId: string) => DataProducer | undefined;
};
export type TransportInternal = RouterInternal & {
    transportId: string;
};
type TransportData = WebRtcTransportData | PlainTransportData | PipeTransportData | DirectTransportData;
export declare abstract class TransportImpl<TransportAppData extends AppData = AppData, Events extends TransportEvents = TransportEvents, Observer extends TransportObserver = TransportObserver> extends EnhancedEventEmitter<Events> implements Transport {
    #private;
    protected readonly internal: TransportInternal;
    protected readonly channel: Channel;
    protected readonly getProducerById: (producerId: string) => Producer | undefined;
    protected readonly getDataProducerById: (dataProducerId: string) => DataProducer | undefined;
    protected readonly consumers: Map<string, Consumer>;
    protected readonly dataProducers: Map<string, DataProducer>;
    protected readonly dataConsumers: Map<string, DataConsumer>;
    protected constructor({ internal, data, channel, appData, getRouterRtpCapabilities, getProducerById, getDataProducerById, }: TransportConstructorOptions<TransportAppData>, observer: Observer);
    get id(): string;
    get closed(): boolean;
    abstract get type(): TransportType;
    get appData(): TransportAppData;
    set appData(appData: TransportAppData);
    get observer(): Observer;
    /**
     * Just for testing purposes.
     */
    get channelForTesting(): Channel;
    close(): void;
    routerClosed(): void;
    listenServerClosed(): void;
    abstract dump(): Promise<any>;
    abstract getStats(): Promise<any[]>;
    abstract connect(params: any): Promise<void>;
    setMaxIncomingBitrate(bitrate: number): Promise<void>;
    setMaxOutgoingBitrate(bitrate: number): Promise<void>;
    setMinOutgoingBitrate(bitrate: number): Promise<void>;
    produce<ProducerAppData extends AppData = AppData>({ id, kind, rtpParameters, paused, keyFrameRequestDelay, appData, }: ProducerOptions<ProducerAppData>): Promise<Producer<ProducerAppData>>;
    consume<ConsumerAppData extends AppData = AppData>({ producerId, rtpCapabilities, paused, mid, preferredLayers, ignoreDtx, enableRtx, pipe, appData, }: ConsumerOptions<ConsumerAppData>): Promise<Consumer<ConsumerAppData>>;
    produceData<DataProducerAppData extends AppData = AppData>({ id, sctpStreamParameters, label, protocol, paused, appData, }?: DataProducerOptions<DataProducerAppData>): Promise<DataProducer<DataProducerAppData>>;
    consumeData<DataConsumerAppData extends AppData = AppData>({ dataProducerId, ordered, maxPacketLifeTime, maxRetransmits, paused, subchannels, appData, }: DataConsumerOptions<DataConsumerAppData>): Promise<DataConsumer<DataConsumerAppData>>;
    enableTraceEvent(types?: TransportTraceEventType[]): Promise<void>;
    private getNextSctpStreamId;
}
export declare function portRangeToFbs(portRange?: TransportPortRange): FbsTransport.PortRangeT;
export declare function socketFlagsToFbs(flags?: TransportSocketFlags): FbsTransport.SocketFlagsT;
export declare function parseSctpState(fbsSctpState: FbsSctpState): SctpState;
export declare function parseProtocol(protocol: FbsTransport.Protocol): TransportProtocol;
export declare function serializeProtocol(protocol: TransportProtocol): FbsTransport.Protocol;
export declare function parseTuple(binary: FbsTransport.Tuple): TransportTuple;
export declare function parseBaseTransportDump(binary: FbsTransport.Dump): BaseTransportDump;
export declare function parseBaseTransportStats(binary: FbsTransport.Stats): BaseTransportStats;
export declare function parseTransportTraceEventData(trace: FbsTransport.TraceNotification): TransportTraceEventData;
export {};
//# sourceMappingURL=Transport.d.ts.map