"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.DumpT = exports.Dump = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
class Dump {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsDump(bb, obj) {
        return (obj || new Dump()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsDump(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new Dump()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    payloadType() {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : 0;
    }
    sequenceNumber() {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.readUint16(this.bb_pos + offset) : 0;
    }
    timestamp() {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : 0;
    }
    marker() {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? !!this.bb.readInt8(this.bb_pos + offset) : false;
    }
    ssrc() {
        const offset = this.bb.__offset(this.bb_pos, 12);
        return offset ? this.bb.readUint32(this.bb_pos + offset) : 0;
    }
    isKeyFrame() {
        const offset = this.bb.__offset(this.bb_pos, 14);
        return offset ? !!this.bb.readInt8(this.bb_pos + offset) : false;
    }
    size() {
        const offset = this.bb.__offset(this.bb_pos, 16);
        return offset ? this.bb.readUint64(this.bb_pos + offset) : BigInt('0');
    }
    payloadSize() {
        const offset = this.bb.__offset(this.bb_pos, 18);
        return offset ? this.bb.readUint64(this.bb_pos + offset) : BigInt('0');
    }
    spatialLayer() {
        const offset = this.bb.__offset(this.bb_pos, 20);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : 0;
    }
    temporalLayer() {
        const offset = this.bb.__offset(this.bb_pos, 22);
        return offset ? this.bb.readUint8(this.bb_pos + offset) : 0;
    }
    mid(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 24);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    rid(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 26);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    rrid(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 28);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    wideSequenceNumber() {
        const offset = this.bb.__offset(this.bb_pos, 30);
        return offset ? this.bb.readUint16(this.bb_pos + offset) : null;
    }
    static startDump(builder) {
        builder.startObject(14);
    }
    static addPayloadType(builder, payloadType) {
        builder.addFieldInt8(0, payloadType, 0);
    }
    static addSequenceNumber(builder, sequenceNumber) {
        builder.addFieldInt16(1, sequenceNumber, 0);
    }
    static addTimestamp(builder, timestamp) {
        builder.addFieldInt32(2, timestamp, 0);
    }
    static addMarker(builder, marker) {
        builder.addFieldInt8(3, +marker, +false);
    }
    static addSsrc(builder, ssrc) {
        builder.addFieldInt32(4, ssrc, 0);
    }
    static addIsKeyFrame(builder, isKeyFrame) {
        builder.addFieldInt8(5, +isKeyFrame, +false);
    }
    static addSize(builder, size) {
        builder.addFieldInt64(6, size, BigInt('0'));
    }
    static addPayloadSize(builder, payloadSize) {
        builder.addFieldInt64(7, payloadSize, BigInt('0'));
    }
    static addSpatialLayer(builder, spatialLayer) {
        builder.addFieldInt8(8, spatialLayer, 0);
    }
    static addTemporalLayer(builder, temporalLayer) {
        builder.addFieldInt8(9, temporalLayer, 0);
    }
    static addMid(builder, midOffset) {
        builder.addFieldOffset(10, midOffset, 0);
    }
    static addRid(builder, ridOffset) {
        builder.addFieldOffset(11, ridOffset, 0);
    }
    static addRrid(builder, rridOffset) {
        builder.addFieldOffset(12, rridOffset, 0);
    }
    static addWideSequenceNumber(builder, wideSequenceNumber) {
        builder.addFieldInt16(13, wideSequenceNumber, null);
    }
    static endDump(builder) {
        const offset = builder.endObject();
        return offset;
    }
    static createDump(builder, payloadType, sequenceNumber, timestamp, marker, ssrc, isKeyFrame, size, payloadSize, spatialLayer, temporalLayer, midOffset, ridOffset, rridOffset, wideSequenceNumber) {
        Dump.startDump(builder);
        Dump.addPayloadType(builder, payloadType);
        Dump.addSequenceNumber(builder, sequenceNumber);
        Dump.addTimestamp(builder, timestamp);
        Dump.addMarker(builder, marker);
        Dump.addSsrc(builder, ssrc);
        Dump.addIsKeyFrame(builder, isKeyFrame);
        Dump.addSize(builder, size);
        Dump.addPayloadSize(builder, payloadSize);
        Dump.addSpatialLayer(builder, spatialLayer);
        Dump.addTemporalLayer(builder, temporalLayer);
        Dump.addMid(builder, midOffset);
        Dump.addRid(builder, ridOffset);
        Dump.addRrid(builder, rridOffset);
        if (wideSequenceNumber !== null)
            Dump.addWideSequenceNumber(builder, wideSequenceNumber);
        return Dump.endDump(builder);
    }
    unpack() {
        return new DumpT(this.payloadType(), this.sequenceNumber(), this.timestamp(), this.marker(), this.ssrc(), this.isKeyFrame(), this.size(), this.payloadSize(), this.spatialLayer(), this.temporalLayer(), this.mid(), this.rid(), this.rrid(), this.wideSequenceNumber());
    }
    unpackTo(_o) {
        _o.payloadType = this.payloadType();
        _o.sequenceNumber = this.sequenceNumber();
        _o.timestamp = this.timestamp();
        _o.marker = this.marker();
        _o.ssrc = this.ssrc();
        _o.isKeyFrame = this.isKeyFrame();
        _o.size = this.size();
        _o.payloadSize = this.payloadSize();
        _o.spatialLayer = this.spatialLayer();
        _o.temporalLayer = this.temporalLayer();
        _o.mid = this.mid();
        _o.rid = this.rid();
        _o.rrid = this.rrid();
        _o.wideSequenceNumber = this.wideSequenceNumber();
    }
}
exports.Dump = Dump;
class DumpT {
    payloadType;
    sequenceNumber;
    timestamp;
    marker;
    ssrc;
    isKeyFrame;
    size;
    payloadSize;
    spatialLayer;
    temporalLayer;
    mid;
    rid;
    rrid;
    wideSequenceNumber;
    constructor(payloadType = 0, sequenceNumber = 0, timestamp = 0, marker = false, ssrc = 0, isKeyFrame = false, size = BigInt('0'), payloadSize = BigInt('0'), spatialLayer = 0, temporalLayer = 0, mid = null, rid = null, rrid = null, wideSequenceNumber = null) {
        this.payloadType = payloadType;
        this.sequenceNumber = sequenceNumber;
        this.timestamp = timestamp;
        this.marker = marker;
        this.ssrc = ssrc;
        this.isKeyFrame = isKeyFrame;
        this.size = size;
        this.payloadSize = payloadSize;
        this.spatialLayer = spatialLayer;
        this.temporalLayer = temporalLayer;
        this.mid = mid;
        this.rid = rid;
        this.rrid = rrid;
        this.wideSequenceNumber = wideSequenceNumber;
    }
    pack(builder) {
        const mid = (this.mid !== null ? builder.createString(this.mid) : 0);
        const rid = (this.rid !== null ? builder.createString(this.rid) : 0);
        const rrid = (this.rrid !== null ? builder.createString(this.rrid) : 0);
        return Dump.createDump(builder, this.payloadType, this.sequenceNumber, this.timestamp, this.marker, this.ssrc, this.isKeyFrame, this.size, this.payloadSize, this.spatialLayer, this.temporalLayer, mid, rid, rrid, this.wideSequenceNumber);
    }
}
exports.DumpT = DumpT;
