"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.RtpParametersT = exports.RtpParameters = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const rtcp_parameters_1 = require("../../fbs/rtp-parameters/rtcp-parameters");
const rtp_codec_parameters_1 = require("../../fbs/rtp-parameters/rtp-codec-parameters");
const rtp_encoding_parameters_1 = require("../../fbs/rtp-parameters/rtp-encoding-parameters");
const rtp_header_extension_parameters_1 = require("../../fbs/rtp-parameters/rtp-header-extension-parameters");
class RtpParameters {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsRtpParameters(bb, obj) {
        return (obj || new RtpParameters()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsRtpParameters(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new RtpParameters()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    mid(optionalEncoding) {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.__string(this.bb_pos + offset, optionalEncoding) : null;
    }
    codecs(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? (obj || new rtp_codec_parameters_1.RtpCodecParameters()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    codecsLength() {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    headerExtensions(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? (obj || new rtp_header_extension_parameters_1.RtpHeaderExtensionParameters()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    headerExtensionsLength() {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    encodings(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? (obj || new rtp_encoding_parameters_1.RtpEncodingParameters()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    encodingsLength() {
        const offset = this.bb.__offset(this.bb_pos, 10);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    rtcp(obj) {
        const offset = this.bb.__offset(this.bb_pos, 12);
        return offset ? (obj || new rtcp_parameters_1.RtcpParameters()).__init(this.bb.__indirect(this.bb_pos + offset), this.bb) : null;
    }
    static startRtpParameters(builder) {
        builder.startObject(5);
    }
    static addMid(builder, midOffset) {
        builder.addFieldOffset(0, midOffset, 0);
    }
    static addCodecs(builder, codecsOffset) {
        builder.addFieldOffset(1, codecsOffset, 0);
    }
    static createCodecsVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startCodecsVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static addHeaderExtensions(builder, headerExtensionsOffset) {
        builder.addFieldOffset(2, headerExtensionsOffset, 0);
    }
    static createHeaderExtensionsVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startHeaderExtensionsVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static addEncodings(builder, encodingsOffset) {
        builder.addFieldOffset(3, encodingsOffset, 0);
    }
    static createEncodingsVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startEncodingsVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static addRtcp(builder, rtcpOffset) {
        builder.addFieldOffset(4, rtcpOffset, 0);
    }
    static endRtpParameters(builder) {
        const offset = builder.endObject();
        builder.requiredField(offset, 6); // codecs
        builder.requiredField(offset, 8); // header_extensions
        builder.requiredField(offset, 10); // encodings
        builder.requiredField(offset, 12); // rtcp
        return offset;
    }
    unpack() {
        return new RtpParametersT(this.mid(), this.bb.createObjList(this.codecs.bind(this), this.codecsLength()), this.bb.createObjList(this.headerExtensions.bind(this), this.headerExtensionsLength()), this.bb.createObjList(this.encodings.bind(this), this.encodingsLength()), (this.rtcp() !== null ? this.rtcp().unpack() : null));
    }
    unpackTo(_o) {
        _o.mid = this.mid();
        _o.codecs = this.bb.createObjList(this.codecs.bind(this), this.codecsLength());
        _o.headerExtensions = this.bb.createObjList(this.headerExtensions.bind(this), this.headerExtensionsLength());
        _o.encodings = this.bb.createObjList(this.encodings.bind(this), this.encodingsLength());
        _o.rtcp = (this.rtcp() !== null ? this.rtcp().unpack() : null);
    }
}
exports.RtpParameters = RtpParameters;
class RtpParametersT {
    mid;
    codecs;
    headerExtensions;
    encodings;
    rtcp;
    constructor(mid = null, codecs = [], headerExtensions = [], encodings = [], rtcp = null) {
        this.mid = mid;
        this.codecs = codecs;
        this.headerExtensions = headerExtensions;
        this.encodings = encodings;
        this.rtcp = rtcp;
    }
    pack(builder) {
        const mid = (this.mid !== null ? builder.createString(this.mid) : 0);
        const codecs = RtpParameters.createCodecsVector(builder, builder.createObjectOffsetList(this.codecs));
        const headerExtensions = RtpParameters.createHeaderExtensionsVector(builder, builder.createObjectOffsetList(this.headerExtensions));
        const encodings = RtpParameters.createEncodingsVector(builder, builder.createObjectOffsetList(this.encodings));
        const rtcp = (this.rtcp !== null ? this.rtcp.pack(builder) : 0);
        RtpParameters.startRtpParameters(builder);
        RtpParameters.addMid(builder, mid);
        RtpParameters.addCodecs(builder, codecs);
        RtpParameters.addHeaderExtensions(builder, headerExtensions);
        RtpParameters.addEncodings(builder, encodings);
        RtpParameters.addRtcp(builder, rtcp);
        return RtpParameters.endRtpParameters(builder);
    }
}
exports.RtpParametersT = RtpParametersT;
