"use strict";
// automatically generated by the FlatBuffers compiler, do not modify
Object.defineProperty(exports, "__esModule", { value: true });
exports.RtpListenerT = exports.RtpListener = void 0;
/* eslint-disable @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any, @typescript-eslint/no-non-null-assertion */
const flatbuffers = require("flatbuffers");
const string_string_1 = require("../../fbs/common/string-string");
const uint32_string_1 = require("../../fbs/common/uint32-string");
class RtpListener {
    bb = null;
    bb_pos = 0;
    __init(i, bb) {
        this.bb_pos = i;
        this.bb = bb;
        return this;
    }
    static getRootAsRtpListener(bb, obj) {
        return (obj || new RtpListener()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    static getSizePrefixedRootAsRtpListener(bb, obj) {
        bb.setPosition(bb.position() + flatbuffers.SIZE_PREFIX_LENGTH);
        return (obj || new RtpListener()).__init(bb.readInt32(bb.position()) + bb.position(), bb);
    }
    ssrcTable(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? (obj || new uint32_string_1.Uint32String()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    ssrcTableLength() {
        const offset = this.bb.__offset(this.bb_pos, 4);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    midTable(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? (obj || new string_string_1.StringString()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    midTableLength() {
        const offset = this.bb.__offset(this.bb_pos, 6);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    ridTable(index, obj) {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? (obj || new string_string_1.StringString()).__init(this.bb.__indirect(this.bb.__vector(this.bb_pos + offset) + index * 4), this.bb) : null;
    }
    ridTableLength() {
        const offset = this.bb.__offset(this.bb_pos, 8);
        return offset ? this.bb.__vector_len(this.bb_pos + offset) : 0;
    }
    static startRtpListener(builder) {
        builder.startObject(3);
    }
    static addSsrcTable(builder, ssrcTableOffset) {
        builder.addFieldOffset(0, ssrcTableOffset, 0);
    }
    static createSsrcTableVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startSsrcTableVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static addMidTable(builder, midTableOffset) {
        builder.addFieldOffset(1, midTableOffset, 0);
    }
    static createMidTableVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startMidTableVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static addRidTable(builder, ridTableOffset) {
        builder.addFieldOffset(2, ridTableOffset, 0);
    }
    static createRidTableVector(builder, data) {
        builder.startVector(4, data.length, 4);
        for (let i = data.length - 1; i >= 0; i--) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }
    static startRidTableVector(builder, numElems) {
        builder.startVector(4, numElems, 4);
    }
    static endRtpListener(builder) {
        const offset = builder.endObject();
        builder.requiredField(offset, 4); // ssrc_table
        builder.requiredField(offset, 6); // mid_table
        builder.requiredField(offset, 8); // rid_table
        return offset;
    }
    static createRtpListener(builder, ssrcTableOffset, midTableOffset, ridTableOffset) {
        RtpListener.startRtpListener(builder);
        RtpListener.addSsrcTable(builder, ssrcTableOffset);
        RtpListener.addMidTable(builder, midTableOffset);
        RtpListener.addRidTable(builder, ridTableOffset);
        return RtpListener.endRtpListener(builder);
    }
    unpack() {
        return new RtpListenerT(this.bb.createObjList(this.ssrcTable.bind(this), this.ssrcTableLength()), this.bb.createObjList(this.midTable.bind(this), this.midTableLength()), this.bb.createObjList(this.ridTable.bind(this), this.ridTableLength()));
    }
    unpackTo(_o) {
        _o.ssrcTable = this.bb.createObjList(this.ssrcTable.bind(this), this.ssrcTableLength());
        _o.midTable = this.bb.createObjList(this.midTable.bind(this), this.midTableLength());
        _o.ridTable = this.bb.createObjList(this.ridTable.bind(this), this.ridTableLength());
    }
}
exports.RtpListener = RtpListener;
class RtpListenerT {
    ssrcTable;
    midTable;
    ridTable;
    constructor(ssrcTable = [], midTable = [], ridTable = []) {
        this.ssrcTable = ssrcTable;
        this.midTable = midTable;
        this.ridTable = ridTable;
    }
    pack(builder) {
        const ssrcTable = RtpListener.createSsrcTableVector(builder, builder.createObjectOffsetList(this.ssrcTable));
        const midTable = RtpListener.createMidTableVector(builder, builder.createObjectOffsetList(this.midTable));
        const ridTable = RtpListener.createRidTableVector(builder, builder.createObjectOffsetList(this.ridTable));
        return RtpListener.createRtpListener(builder, ssrcTable, midTable, ridTable);
    }
}
exports.RtpListenerT = RtpListenerT;
